function [ixelt, rc] = mfs_findelts(indx, eltsel, eset)

# usage: [ixelt, rc] = mfs_findelts(indx, eltsel, eset)
#
# Input  indx(:, 3)   Element index
#        eltsel       List of element identifiers or name of an
#                     element set or cell array with element set names
#        eset         Structure with element sets
#
# Output ixelt(:)     Element indices within structure array elem
#        rc           Return code: 0 means no errors
#
# The function returns the element indices for a set of element
# identifiers.
#
# --------------------------------------------------------------------

  rc    = 0;
  ixelt = [];

  if (ischar(eltsel))

# Element set

     if (isfield(eset, eltsel))
        ix = eset.(eltsel);
     else
        rc = 1;
        printf("*E* element set %s does not exist\n", eltsel);
     end

  elseif (iscell(eltsel))

     nofset = length(eltsel); ix = [];
     for n = 1 : nofset
        if(isfield(eset, eltsel{n}))
           ix = [ix, eset.(eltsel{n})];
        else
           rc = 1;
           printf("*E* element set %s does not exist\n", eltsel{n});
        end
     end

# Cell array with element sets

  else

# List of element identifiers

     ix     = lookup(indx(:, 1), eltsel, "m");
     badelt = find(ix == 0);
     if (! isempty(badelt))
        for bad = badelt
            printf("*E* element %6d does not exist\n", eltsel(bad));
        end
        rc = 1;
     end

  end

  if (rc) return; end

  ixelt = indx(ix, 2); 

end
