function mot  = mfs_getmotion(resp, ixdof, type, modes, ndofr)

# usage: mot  = mfs_getmotion(resp, ixdof, type, modes, ndofr)
#
# Input  resp         Structure with transient response results
#        ixdof(:)     Array with degree of freedom indices
#        type         Motion type: 1 = displacement
#                                  2 = velocity
#                                  3 = acceleration
#        modes(:, :)  Matrix with normal modes
#        ndofr        Number of rigid body modes
#
# Output mot(:, :)    Array with motion
#                     (columns correspond to time steps)
#
# The function returns the time-dependent motion of selected degrees
# of freedom.
#
# -------------------------------------------------------------------------

  fn  = {"f", "fd", "fdd"};
  qn  = {"q", "qd", "qdd"};
  un  = {"u", "v", "a"};
  uen = {"ue", "ve", "ae"};

# Check arguments

  if (nargin != 5 || nargout != 1)
     print_usage();
  end 

# Get motion

  if (resp.method == 1)
     mot = resp.(un{type})(ixdof, :);
  elseif (resp.method == 4)
     mot = resp.(uen{type})(ixdof, :);
     if (ndofr)
        mot += modes(ixdof, 1 : ndofr) * resp.(qn{type})(1 : ndofr, :);
     end
  else
     X = modes(ixdof, :);
     if (resp.method == 3)
        X = [X, resp.Xs(ixdof, :)];
     end
     mot  = X * resp.(qn{type});
     if (isfield(resp, "base"))
        mot += resp.base(ixdof, :) * resp.(fn{type});
     end
  end

end
