function rslt = mfs_getresultant3d(elem, ixelt, cols)

# usage: rslt = mfs_getresultant3d(elem, ixelt, cols)
#
# Input  elem(:, :)  Structure array with element results
#        ixelt(:)    List of element indices
#        cols(:)     Column indices
#
# Output rslt{:}    Cell array with stress resultants
#
# The function returns a cell array of structures containing the
# stress resultants of 3d-elements. The fields of the structure depend
# on the result type.
#
# Column indices correspond to loadcases or excitation frequencies,
# depending on the class of results.
#
# --------------------------------------------------------------------

  nofelt = length(ixelt);
  rslt   = cell(nofelt, 1);

  for n = 1 : nofelt

      ixe  = ixelt(n);
      res  = elem(ixe);
      rtype = res.rtype;

      if (rtype == 0)
         printf("*E* Requested results not implemented for element %5.0d\n",
                res.id);
         continue;
      end

#     Fields common to all result types

      s = struct("id", res.id, "nofpnt", res.nofpnt,
                 "nofcol", length(cols), "coor", res.coor,
                 "rtype", rtype);

#     Fields depending on result type

      switch rtype

        case 1 % beam

           resultants = res.results.rslt;

           s.N  = resultants(1, cols);
           s.Qy = resultants(2, cols);
           s.Qz = resultants(3, cols);
           s.Mx = resultants(4, cols);
           s.My = resultants(5, cols);
           s.Mz = resultants(6, cols);

        case 2 % rod

           s.N = res.results.rslt(cols);

        case 4 % shell

           s.TE     = res.results.TE;

           resultants = res.results.rslt;

           s.Nx  = resultants(1, cols);
           s.Ny  = resultants(2, cols);
           s.Nxy = resultants(3, cols);
           s.Mx  = resultants(4, cols);
           s.My  = resultants(5, cols);
           s.Mxy = resultants(6, cols);
           s.Qx  = resultants(7, cols);
           s.Qy  = resultants(8, cols);

      end

      rslt{n} = s;

  end

end
