function rc = mfs_new_chkelts(msg, subtype, elements, nodes)

# usage: rc = mfs_new_chkelts(msg, subtpye, elements, nodes)
#
# Input  msg       File handle of message file
#        subtype   Component subtype 
#        elements  Structure with element data
#        nodes     Structure with node data
#
# Ouput  rc        Return code: 0 means no erros
#                               1 means erros
#
# The function performs basic element checks.
#
# ----------------------------------------------------------------------------

# Check arguments

  if (nargin != 4 || nargout != 1)
     print_usage();
  end

# Initialize

  rc = 0;

# Get base path to element routines

  fname = strcat(mfilename(), ".m");
  bpath = file_in_loadpath(fname);
  len   = length(bpath) - length(fname);
  bpath = strcat(bpath(1 : len), "elem/", subtype, "/");

# Get maximum length

  Lmin = eps * max(abs(nodes.maxcor - nodes.mincor));

# Loop over the elements


  for type = elements.types

      epath = strcat(bpath, type.name);
      addpath(epath);

      if (exist("mfs_chkelt", "file") == 2)
         m1 = type.ixelt1;
         m2 = m1 + type.nofelt - 1;
         rc = rc | mfs_chkelt(msg, elements.elem(m1 : m2), Lmin);
      end

      rmpath(epath);

  end

end
