function [eset, rc] = mfs_new_eset(msg, esetin, eindex)

# usage: [eset, rc] = mfs_new_eset(msg, esetin, eindex)
#
# Input  msg     File handle of message file
#        esetin  Structure with definition of element sets
#        eindex  Element index table from structure elements
#
# Output eset    Structure with element sets
#        rc      Return code: 0 = no errors
#                             1 = errors
#
# The function builds the internal element set structure. The field names
# are identical with the element set names. The fields contain the indices
# in the element index table of the elements in each set.
#
# -----------------------------------------------------------------------------

  nset = struct();
  rc   = 1;

# Check arguments

  if (nargin != 3 || nargout != 2)
     print_usage();
  end

  if (! isstruct(esetin))
     fprintf(msg, "*E* Field eset is not a structure\n");
     return;
  end

  rc = 0;

# Process the sets

  for [list, name] = esetin
      idx  = lookup(eindex(:, 1), list, "m");
      bad  = find(idx == 0);
      nbad = length(bad);
      if (nbad)
         for n = 1 : nbad
             fprintf(msg, "*E* Element %6d referenced by set %s does not exist\n",
                     list(bad(n)), name); 
         end
         rc = 1;
      else
         eset.(name) = idx(:)';
      end
  end

end
