function [nset, rc] = mfs_new_nset(msg, nsetin, nodes)

# usage: [nset, rc] = mfs_new_nset(msg, nsetin, nodes)
#
# Input  msg     File handle of message file
#        nsetin  Structure with definition of node sets
#        nodes   Structure with nodal point data
#
# Output nset    Structure with node sets
#        rc      Return code: 0 = no errors
#                             1 = errors
#
# The function builds the internal node set structure. The field names
# are identical with the node set names. The fields contain the indices
# of the nodal points in each set.
#
# -----------------------------------------------------------------------------

  nset = struct();
  rc   = 1;

# Check arguments

  if (nargin != 3 || nargout != 2)
     print_usage();
  end

  if (! isstruct(nsetin))
     fprintf(msg, "*E* Field nset is not a structure\n");
     return;
  end

  rc = 0;

# Process the sets

  for [list, name] = nsetin
      idx  = lookup(nodes.ids, list, "m");
      bad  = find(idx == 0);
      nbad = length(bad);
      if (nbad)
         for n = 1 : nbad
             fprintf(msg, "*E* Node %6d referenced by set %s does not exist\n",
                     list(bad(n)), name); 
         end
         rc = 1;
      else
         nset.(name) = idx(:)';
      end
  end

end
