function disp = mfs_plot_defscal(nodes, disp, mxdofpnt, scale, lcs)

# usage: disp = mfs_plot_defscal(nodes, disp, mxdofpnt, scale)
#
# Input  nodes     Structure with nodal point data
#        disp      Displacement matrix
#        mxdofpnt  Maximum number of Dofs per nodal point
#        scale     Scale factor
#        lcs(:)    Loadcase list
#
# Output disp      Scaled displacement matrix
#
# The function scales the displacements so that the largest
# displacement is scale * largest model dimension.
#
# ------------------------------------------------------------------------

# Largest model dimension

  Lmax = max(nodes.maxcor - nodes.mincor);

# Largest displacement (do not include rotations)

  tdof  = nodes.ncoor;
  rdof  = mxdofpnt - tdof;

  if (rdof)
     index = zeros(tdof * nodes.nofnod, 1);
     k = 1;
     l = 1;
     for n = 1 : nodes.nofnod
         for m = 1 : tdof
            index(k++) = l++;
         end
         l += rdof;
     end
     umax = max(abs(disp(index, lcs)));
  else
     umax = max(abs(disp(:, lcs)));
  end

# Look for zero displacements

  if (! all(umax))
     lcz = find(umax == 0);
     for l = lcz
         umax(l) = 1;
         printf("*W* mfs_plot: displacements of loadcase/mode ");
         printf("%3d are all zero\n", lcs(l));
     end
  end

# Scale displacements

  sf           = diag(scale * Lmax ./ umax);
  disp(:, lcs) = disp(:, lcs) * sf;

end
