function elem = mfs_plot_elcor(elements, nodes)

# usage: elem = mfs_plot_elcor(elements, nodes)
#
# Input  elements    Structure with element data 
#        nodes       Structure with nodal point data
#      
# Output elem        Structure array with element data
#                    (with modified coordinates) 
#
# The function inserts the nodal point coordinates into the structure with
# the element data. Only one loading case can be processed.
#
# ------------------------------------------------------------------------

  nodeids = nodes.ids;
  coor    = nodes.coor;
  elem    = elements.elem;

  for n = 1 : elements.nofelt
      ix = elem(n).nodes;
      elem(n).coor = coor(ix, :);
  end

end
