function mfs_plot_elements(elements, type, subtype);

# usage: mfs_plot_elements(elements)
#
# Input elements   Structure with element data
#       type       Component type
#       subtype    Component subtype
#
# The function plots the elements of a solid component.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin != 3)
     print_usage();
  end

# Build path to element routines

  fname = strcat(mfilename(), ".m");
  bpath = file_in_loadpath(fname);
  len   = length(bpath) - length(fname);
  bpath = strcat(bpath(1 : len), "elem/", subtype, "/");

# Loop over element types

  for ntype = 1 : elements.noftyp

      epath = strcat(bpath, elements.types(ntype).name);
      addpath(epath);

      if (exist("mfs_pltelt", "file") == 2)
         nofelt = elements.types(ntype).nofelt;
         ix1    = elements.types(ntype).ixelt1;
         ix2    = ix1 + nofelt - 1;
         mfs_pltelt(nofelt, elements.elem(ix1:ix2));
      end

      rmpath(epath);

  end

end
