function Fmax = mfs_plot_force(nodes, force, subtype, color, labels,
                               Fmax);

# usage: mfs_plot_force(nodes, force, subtrype, color)
#
# Input  nodes    Structure with node data
#        force    Structure with force data
#        subtype  Component subtype
#        color    Color
#        labels   Controls printing of labels
#        Fmax     Maximum force
#
# Output Fmax     Maximum force
#
# This function plots force arrows and optionally labels them.
#
# -------------------------------------------------------------------

  global pltparm;

  axes = {"x", "y", "z"};

  if (isempty(force.d))
     return;
  end

  ncoor = nodes.ncoor;
  if (! Fmax)
     Fmax = max(max(abs(force.d(:, 1 : ncoor))));
     if (Fmax == 0)
        return;
     end
  end

  switch subtype

  case "2d"

     Lmax = max(nodes.maxcor - nodes.mincor);
     sf = pltparm.scalf * Lmax / Fmax;

     fs = pltparm.fontsize;

     for n = 1 : force.nofnod
         ix = force.id(n);
         sp = nodes.coor(ix, :);
         for k = 1 : ncoor
            if (force.d(n, k))
               len = force.d(n, k) * sf;
               if (labels)
                  labf = sprintf("%8.2f", abs(force.d(n, k)));
                  mfs_arrow2d(sp, len, axes{k}, color, labf, fs); 
               else
                  mfs_arrow2d(sp, len, axes{k}, color);
               end
            end
         end       % Loop k
     end           % Loop n

  case "3d"

     Lmax = max(nodes.maxcor - nodes.mincor);
     sf = pltparm.scalf * Lmax / Fmax;

     fs = pltparm.fontsize;

     for n = 1 : force.nofnod
         ix = force.id(n);
         sp = nodes.coor(ix, :);
         for k = 1 : ncoor
            if (force.d(n, k))
               len = force.d(n, k) * sf;
               if (labels)
                  labf = sprintf("%8.2f", abs(force.d(n, k)));
                  mfs_arrow3d(sp, len, axes{k}, color, labf, fs); 
               else
                  mfs_arrow3d(sp, len, axes{k}, color);
               end
            end
         end       % Loop k
     end           % Loop n
         
  end

end
