function coor = mfs_plot_noddef(nodes, disp, mxdofpnt)

# usage: coor = mfs_plot_noddef(nodes, disp, mxdofpnt)
#
# Input  nodes          Structure with nodal point data 
#        disp           Displacement matrix 
#        mxdofpnt       Maximum number of dofs per nodal point
#        ncoor          Number of coordinates
#      
# Output coor(:, ncoor) Array with modified coordinates
#
# The function adds the displacements to the nodal point coordinates. Only
# one loading case can be processed.
#
# ------------------------------------------------------------------------

  def  = reshape(disp, mxdofpnt, nodes.nofnod)';
  coor = nodes.coor + def(:, 1 : nodes.ncoor);

end
