function mfs_plot_nodes(nodes, subtype);

# usage: mfs_plot_nodes(nodes, subtype)
#
# Input nodes      Structure with node data
#       subtype    Component subtype
#
# The function plots the node labels.
#
# Description of the node structure:
#
#    nodes.nofnod           Anzahl der Knotenpunkte
#    nodes.maxcor(2)        Maximalwerte der Koordinaten
#    nodes.mincor(2)        Minimalwerte der Koordinaten
#    nodes.ids(:)           Identifikatoren der Knotenpunkte
#    nodes.coor(:, 2)       Koordinaten: x, y
#
# ------------------------------------------------------------------------

  global pltparm;

  switch subtype

  case "2d"
 
     for node = 1 : nodes.nofnod
         label = sprintf("%d", nodes.ids(node));
         text(nodes.coor(node, 1), nodes.coor(node, 2), label);
     end

  case "3d"
 
     for node = 1 : nodes.nofnod
         label = sprintf("%d", nodes.ids(node));
         text(nodes.coor(node, 1), nodes.coor(node, 2), ...
              nodes.coor(node, 3), label);
     end

  end

end
