function mfs_plot_title(label, subtype);

# usage: mfs_plot_title(label, subtype)
#
# Input:  label     Plot label
#         subtype   Component subtype
#
# This function writes a label to the plot.
#
# -------------------------------------------------------------------

  h = gca();

  switch subtype

  case "2d"

     xlim = get(h, "xlim");
     ylim = get(h, "ylim");

     x = xlim(1) - 0.01 * (xlim(2) - xlim(1));
     y = ylim(2) + 0.05 * (ylim(2) - ylim(1));

     text(x, y, label);

  case "3d"

     title(label);

  end

end
