function mfs_prt_elres(fid, elres, type, titles, select)

# usage: mfs_prt_elres(fid, elres, type, titles, select)
#
# Input  fid        File handle
#        elres      Structure with element results
#        type       Result type
#        titles{:}  Cell array with titles
#        select     List of indices of elements selected for output
#
# The function prints element results.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin < 4 || nargin > 7)
     print_usage();
  end

  nosel =  (nargin == 4 || isempty(select));

# Get base path to element routines

  fname = strcat(mfilename(), ".m");
  bpath = file_in_loadpath(fname);
  len   = length(bpath) - length(fname);
  bpath = strcat(bpath(1 : len), "elem/", elres.subtype, "/");

# Loop over columns and element types

  nlc = elres.nofcol;

  for lc = 1 : nlc

     fprintf(fid, "%s\n\n", titles{lc});

     if (nosel)

        for ntype = 1 : elres.noftyp

            epath = strcat(bpath, elres.types(ntype).name);
            addpath(epath);

            if (exist("mfs_prtelt", "file") == 2)
               nofelt = elres.types(ntype).nofelt;
               ix1    = elres.types(ntype).ixelt1;
               ix2    = ix1 + nofelt - 1;
               mfs_prtelt(fid, nofelt, elres.elem(ix1:ix2), lc, type);
            end

            rmpath(epath);

        end

     else

        for ntype = 1 : elres.noftyp

            epath = strcat(bpath, elres.types(ntype).name);
            addpath(epath);

            if (exist("mfs_prtelt", "file") == 2)
               nofelt = elres.types(ntype).nofelt;
               ix1    = elres.types(ntype).ixelt1;
               ix2    = ix1 + nofelt - 1;
               ixs    = intersect(select, ix1 : ix2);
               nofsel = length(ixs);
               if (! isempty(ixs))
                  mfs_prtelt(fid, nofsel, elres.elem(ixs), lc,
                              type);
               end
            end

            rmpath(epath);

        end

     end

  end

end
