function mfs_prt_freq(fid, cmp)

# usage: mfs_prt_freq(fid, cmp)
#
# Input  fid       File handle
#        cmp       Structure with component
#
# The function prints the natural frequencies.
#
# ------------------------------------------------------------------------

  fprintf(fid, "Natural frequencies:\n\n");
  fprintf(fid, "  Mode   Circ. Frequency    Frequency\n");
  fprintf(fid, "  ---------------------------------------\n");

  for m = 1 : cmp.modes.nofmod
      fprintf(fid, "  %4d    %12.5f  %12.5f Hz\n", ...
              m, cmp.modes.omega(m), cmp.modes.freq(m));
  end

  fprintf(fid, "\n");

end
