function mfs_prt_modes(fid, cmp, headers, select)

# usage: mfs_prt_modes(fid, cmp, headers, select)
#
# Input  fid       File handle
#        cmp       Structure with component
#        headers   Displacement headers
#        select    List of indices of nodal points selected for
#                  output
#
# The function prints the free vibration modes.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin < 3 || nargin > 4)
     print_usage();
  end

  nosel = (nargin == 3 || isempty(select));

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  mxdofpnt = cmp.dofs.mxdofpnt;
  [m, nofmod] = size(cmp.modes.disp);

# Loop over modes

  for m = 1 : nofmod

     fprintf(fid, "Free vibration mode %2d:", m);
     fprintf(fid, "  Frequency = %10.3f Hz\n\n", cmp.modes.freq(m));

#    Header

     fprintf(fid, "   node    ");
     for k = 1 : mxdofpnt
         fprintf(fid, "     %3s    ", headers{k});
     end
     fprintf(fid, "\n\n");

#    Loop over nodal points

     d = reshape(cmp.modes.disp(:, m), mxdofpnt, nofnod);

     if (nosel)

        for n = 1 : nofnod
            fprintf(fid, "  %6d  ", cmp.nodes.ids(n))
            fprintf(fid, " %11.3e", d(:, n));
            fprintf(fid, "\n");
        end

     else 

        for n = 1 : length(select)
            ix = select(n);
            fprintf(fid, "  %6d  ", cmp.nodes.ids(ix))
            fprintf(fid, " %11.3e", d(:, ix));
            fprintf(fid, "\n");
        end


     end

     fprintf(fid, "\n");

  end

end
