function mfs_prt_nodedata(fid, nodes, data, title, header, typ, res)

# usage: mfs_prt_nodedata(fid, nodes, data, title, header, typ, res)
#
# Input  fid          File handle
#        nodes        Structure with nodal point data
#        data(nofldc) Structure with data to be printed
#        title        Title
#        header       Cell array with column headers
#        typ          Type of load to print:
#                      0  = point loads
#                      1  = prescribed displacements
#                      2  = prescribed velocities
#                      3  = prescribed accelerations
#                      4  = reaction loads
#        res          If defined and not empty, print only resultants.
#
# The function prints data related to nodal points.
#
# ------------------------------------------------------------------------

# Get number of loadcases or modes and number of coordinates

  nofldc = length(data);
  ncoor  = nodes.ncoor;

  rsonly = (nargin == 7 && ! isempty(res));

# Loop over loadcases

  for lc = 1 : nofldc

     nofnod = data(lc).nofnod;

     if (nofnod && data(lc).type == typ)

        ndata = columns(data(lc).d);
        fprintf(fid, "%s %2d\n\n", title, lc);

#    Header

        if (! rsonly)

           fprintf(fid, "   node    ")
           for k = 1 : ndata
               fprintf(fid, "     %3s    ", header{k});
           end
           fprintf(fid, "\n\n");

#    Loop over nodal points

           for n = 1 : nofnod
               node = data(lc).id(n);
               fprintf(fid, "  %6d  ", nodes.ids(node));
               fprintf(fid, " %11.3e", data(lc).d(n, :));
               fprintf(fid, "\n");
           end

           fprintf(fid, "\n");

        end

#    Resultants

        if (typ == 0 || typ == 4)
           fprintf(fid, "   Res.   ");
           fprintf(fid, " %11.3e", data(lc).res);
           fprintf(fid, "\n\n");
        end

     end

  end

end
