function elres = mfs_results_transresp_elem(subtype, elements, disp, velo);

# usage: elres = mfs_results_transresp_elem(subtype, elements, disp, velo)
#
# Input  subtype      Component subtype 
#        elements     Structure with element data
#        disp(:, :)   Displacement matrix
#        velo(:, :)   Velocity matrix
#
# Output elres        Structure with element results
#
# The function computes element results from the frequency response
# of solids.
#
# --------------------------------------------------------------------

# Copy information on number of elements and element types

  elres.subtype = subtype;
  elres.nofelt  = elements.nofelt;
  elres.noftyp  = elements.noftyp;
  elres.types   = elements.types;
  elres.index   = elements.index;

# Get number of time steps

  elres.nofcol = columns(disp);

# Get base path to element routines

  fname = strcat(mfilename(), ".m");
  bpath = file_in_loadpath(fname);
  len   = length(bpath) - length(fname);
  bpath = strcat(bpath(1 : len), "elem/", subtype, "/");

# Loop over element types

  for ntype = 1 : elres.noftyp

      epath = strcat(bpath, elres.types(ntype).name);
      addpath(epath);

      nofelt = elres.types(ntype).nofelt;
      m1     = elres.types(ntype).ixelt1;
      m2     = m1 + nofelt - 1;

      if (exist("mfs_reselt", "file") == 2)
         elres.elem(m1 : m2) = ...
           mfs_reselt(nofelt, elements.elem(m1:m2), disp, 
                      "transresp", velo);
      else
         eltids = num2cell([elements.elem(m1:m2).id]);
         elres.elem(m1 : m2) = struct("id", eltids, "nofpnt", 0,
                                      "coor", 0, "rtype", 0, 
                                      "results", 0);
      end

      rmpath(epath);

  end

end
