function [geom, e, rc] = mfs_bar_section(args)

# usage: [geom, e, rc] = mfs_bar_section(args)
#
# Input  args{1}  Width b
#        args{2}  Height h
#
# Output geom     Structure with geometry data
#        e(2)     ey and ez of center of mass
#        rc       Return code: <> 0 in case of errors
#
# The function computes the cross section properties of a bar section.
#
# -------------------------------------------------------------------------

# Copyright(c) by 2022 Johannes Wandinger

# Initialize

  geom = struct();
  e    = [0, 0];
  rc   = 1;

# Check arguments

  if (length(args) != 2)
     printf("*E* mfs_beamsection: wrong number of parameters for ");
     printf("bar-section\n");
     return;
  endif

  b = args{1}; h = args{2};

  if (b <= 0 || h <= 0)
     printf("*E* mfs_beamsection: bad input data for bar-section: ");
     printf("b = %g, h = %g\n", b, h);
     return;
  endif

# Compute cross section properties

  rc = 0;

  geom.A   = b * h;
  geom.Iy  = b * h^3 / 12;
  geom.Iz  = b^3 * h / 12;
  geom.Iyz = 0;

  % cf. Winkler, Aurich, Taschenbuch der Technischen Mechanik

  t = min(b, h);
  H = max(b, h);
  s = H / t;
  c = (1 - 0.63 / s + 0.052 / s^5) / 3;
  geom.IT  = c * H  * t^3;

endfunction
