function [geom, e, rc] = mfs_circle_section(args)

# usage: [geom, e, rc] = mfs_circle_section(args)
#
# Input  args{1}  Radius r
#
# Output geom     Structure with geometry data
#        e(2)     ey and ez of center of mass
#        rc       Return code: <> 0 in case of errors
#
# The function computes the cross section properties of a circle section.
#
# -------------------------------------------------------------------------

# Copyright(c) by 2022 Johannes Wandinger

# Initialize

  geom = struct();
  e    = [0, 0];
  rc   = 1;

# Check arguments

  if (length(args) != 1)
     printf("*E* mfs_beamsection: wrong number of parameters for ");
     printf("circle-section\n");
     return;
  endif

  r = args{1};

  if (r <= 0)
     printf("*E* mfs_beamsection: bad input data for circle-section: ");
     printf("r = %g\n", r);
     return;
  endif

# Compute cross section properties

  rc = 0;

  geom.A   = pi * r^2;
  geom.Iy  = 0.25 * r^2 * geom.A;
  geom.Iz  = geom.Iy;
  geom.Iyz = 0;
  geom.IT  = 2 * geom.Iy;

endfunction
