function [geom, e, rc] = mfs_bar_section(args)

# usage: [geom, e, rc] = mfs_bar_section(args)
#
# Input  args{:}  Cell array with data defining cross section
#
# Output geom     Structure with geometry data
#        e(2)     ey and ez of center of mass
#        rc       Return code: <> 0 in case of errors
#
# The function computes the cross section properties of a beam cross
# section.
#
# -------------------------------------------------------------------------

# Initialize

  geom = struct();
  e    = [0, 0];
  rc   = 1;

# Check arguments


# Compute cross section properties

  rc = 0;

  % geom.A      area
  % geom.Iy     moment of intertia Iy
  % geom.Iz     moment of inertia Iz
  % geom.Iyz    moment of deviation
  % IT          torsional constant
  % CE(2)       coordinates of the elastic centre in the element
  %             coordinate system
  % e(2)        parameters ey and ez defining the location of the
  %             centre of area

endfunction
