function rc = mfs_checkfields1(msg, struct, fields, text)

# usage: rc = mfs_checkfields1(msg, struct, fields, text)
#
# Input  msg      File handle of message file
#        struct   Structure to check
#        fields   Cell array with names of fields required
#        text     Message text
#
# Output rc       Return code: 0 means no errors
#                              1 means errors
#
# The function checks if the structure has the required fields.
#
# -----------------------------------------------------------------------------

  rc = 0;
  nf = length(fields);

  for n = 1 : nf
      if (! isfield(struct, fields{n}))
         rc = 1;
         fprintf(msg, "*E* %s: Field ""%s"" undefined\n",
                 text, fields{n});
      end
  end

end
