function rc = mfs_checkfields2(msg, struct, fields, item, id)

# usage: rc = mfs_checkfields2(msg, struct, fields, item, id)
#
# Input  msg      File handle of message file
#        struct   Structure to check
#        fields   Cell array with names of fields required
#        item     Name of item processed
#        id       Identifier of item processed
#
# Output rc       Return code: 0 means no errors
#                              1 means errors
#
# The function checks if the structure has the required fields.
#
# -----------------------------------------------------------------------------

  rc = 0;
  nf = length(fields);

  for n = 1 : nf
      if (! isfield(struct, fields{n}))
         rc = 1;
         fprintf(msg, 
                 "*E* %s %5d: Field \"%s\" of structure \"%s\" undefined\n",
                 item, id, fields{n}, inputname(2));
      end
  end

end
