function rc = mfs_checkfields3(msg, struct, legal_fields, item, id)

# usage: rc = mfs_checkfields3(msg, struct, legal_fields, item, id)
#
# Input  msg            File handle of message file
#        struct         Structure to check
#        legal_fields   Cell array with legal field names
#        item           Name of item processed
#        id             Identifier of item processed
#
# Output rc             Return code: 0 means no errors
#                                    1 means errors
#
# The function checks if all fields of the structure have legal names.
#
# -----------------------------------------------------------------------------

  rc     = 0;
  fields = fieldnames(struct);
  nf     = length(fields);

  for n = 1 : nf
      if (! sum(strcmp(fields{n}, legal_fields)))
         rc = 1;
         fprintf(msg, 
                 "*E* %s %5d: Structure ""%s"" has illegal field ""%s""\n",
                 item, id, inputname(2), fields{n});
      end
  end

end
