function rc = mfs_checkfields4(msg, struct, legal_fields, text)

# usage: rc = mfs_checkfields4(msg, struct, legal_fields, msg)
#
# Input  msg            File handle of message file
#        struct         Structure to check
#        legal_fields   Cell array with legal field names
#        text           Text appended to error message
#
# Output rc             Return code: 0 means no errors
#                                    1 means errors
#
# The function checks if all fields of the structure have legal names.
# The checks are identical with those of mfs_checkfields3, but the error
# message is different.
#
# -----------------------------------------------------------------------------

  rc     = 0;
  fields = fieldnames(struct);
  nf     = length(fields);

  for n = 1 : nf
      if (! sum(strcmp(fields{n}, legal_fields)))
         rc = 1;
         fprintf(msg, "*E* %s: Illegal field \"%s\" found\n",
                 text, fields{n});
      end
  end

end
