function [ixdof, rc] = mfs_findnodedofs(nodes, mxdofpnt, nodsel, nset)

# usage: [ixdof, rc] = mfs_findnodedofs(nodes, mxdofpnt, nodsel, nset)
#
# Input  nodes(:)     List of all nodal point identifiers
#        mxdofpnt     Maximum number of dofs per node
#        nodsel       List of nodal point identifiers to be found
#                     or name of a set or cell array with set names
#        nset         Structure with definition of nodal point sets
#
# Output ixdof(mxdofpnt, :)  Indices of dofs in user dof matrices
#        rc                  Return code: 0 means no errors
#
# This function finds the degree of freedom indices for a set of nodes.
#
# ---------------------------------------------------------------------

  rc    = 0;
  ixdof = [];

  if (isnumeric(nodsel))

# List of nodal point identifiers

     nodix = lookup(nodes, nodsel, "m");
     badnod = find(nodix == 0);
     if (! isempty(badnod))
        for ix = badnod
            printf("*E* node %6d does not exist\n", nodsel(ix));
        end
        rc = 1;
        return
     end

  elseif (ischar(nodsel))

# Name of a node set

     if (isfield(nset, nodsel))
        nodix = nset.(nodsel);
     else
        printf("*E* node set %s does not exist\n", nodsel);
        rc = 1;
        return;
     end

  else

# Cell array with set names

     nofset = length(nodel); nodix = [];
     for n = 1 : nofset
        if (isfield(nset, nodsel))
           nodix = [nodix, nset.(nodsel)];
        else
           printf("*E* node set %s does not exist\n", nodsel);
           rc = 1;
        end
     end
     if (rc) return; end
  
  end

  dofs  = [1 : mxdofpnt]';
  ixdof = (nodix - 1) * mxdofpnt + dofs;

end
