function [mat1, mat2] = mfs_matpart(mat, dofs, reqflags)

# usage: [mat1, mat2] = mfs_matpart(mat, dofs, reqflags)
#
# Input  mat          Matrix to be partitioned
#        dofs         Structure with degree of freedom data
#        reqflags(2)  Flags indicating requested partitions:
#                      (1) = 1: LL
#                      (2) = 1: LP
#
# Output mat1, mat2   Requested matrices
#
# If both matrices are requested, mat1 contains LL-partition and mat2
# LP-partition. Otherwise, only the requested matrix is returned.
#
# -----------------------------------------------------------------------------

# Initialize

  mat1 = [];
  mat2 = [];

# Check arguments

  if (nargin != 3 || nargout < 1 || nargout > 2)
     print_usage();
  end

# Process linear constraints

  if (dofs.ndofd)
     mat = dofs.C' * mat * dofs.C;
  end

# Get partitions

  nofreq = sum(reqflags);
  if (nofreq == 1)
     if (reqflags(1))
        mat1 = mat(dofs.dofl, dofs.dofl);
     elseif (dofs.ndofp)
        mat1 = mat(dofs.dofl, dofs.dofp);
     end
  else
     mat1 = mat(dofs.dofl, dofs.dofl);
     if (dofs.ndofp)
        mat2 = mat(dofs.dofl, dofs.dofp);
     end
  end

end
