function matp = mfs_matpartc(mat, dofs)

# usage: matp = mfs_matpartc(mat, dofs)
#
# Input  mat          Matrix to be partitioned
#        dofs         Structure with degree of freedom data
#
# Output matp         Matrix partition
#
# This matrix extracts the L column partition of a matrix.
#
# -----------------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 1)
     print_usage();
  end

# Get partition

  if (dofs.ndofd)
     matp = mat * dofs.C(:, dofs.dofl);
  else
     matp = mat(:, dofs.dofl);
  end

end
