function matp = mfs_matpartr(mat, dofs)

# usage: matp = mfs_matpartr(mat, dofs)
#
# Input  mat          Matrix to be partitioned
#        dofs         Structure with degree of freedom data
#
# Output matp         Matrix partition
#
# This matrix extracts the L row partition of a matrix.
#
# -----------------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 1)
     print_usage();
  end

# Get partition

  if (dofs.ndofd)
     matp = dofs.C(:, dofs.dofl)' * mat;
  else
     matp = mat(dofs.dofl, :);
  end

end
