function mfs_prt_cdisp(fid, nodes, mxdofpnt, disp, titles, headers, select)

# usage: mfs_prt_cdisp(fid, nodes, mxdofpnt, disp, titles, headers, select)
#
# Input  fid          File handle
#        nodes        Structure with node data
#        mxdofpnt     Max. number of dofs per node
#        disp(:, :)   Displacements
#        headers      Displacement headers
#        titles{:}    Cell array with titles
#        select       List of indices of nodal points selected for
#                     output
#
# The function prints complex displacements.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin < 6 || nargin > 7)
     print_usage();
  end

  if (nargin == 7 && ! isempty(select))
     if (ischar(select))
        printf("*W* mfs_print: selector \"%s\" not supported", select);
        printf(" with item \"disp\"\n");
        return;
     else
        nosel = 0;
     end
  else
     nosel = 1;
  end

# Get parameters needed

  nofnod = nodes.nofnod;
  nofcol = columns(disp);

# Loop over frequencies

  for l = 1 : nofcol

     fprintf(fid, "%s\n\n", titles{l});

#    Header

     fprintf(fid, "   node      ");
     for k = 1 : mxdofpnt
         fprintf(fid, "     %3s    ", headers{k});
     end
     fprintf(fid, "\n\n");

#    Loop over nodal points

     d = reshape(disp(:, l), mxdofpnt, nofnod);

     if (nosel)

        for n = 1 : nofnod
            fprintf(fid, "  %6d Re ", nodes.ids(n))
            fprintf(fid, " %11.3e", real(d(:, n)));
            fprintf(fid, "\n");
            fprintf(fid, "         Im ")
            fprintf(fid, " %11.3e", imag(d(:, n)));
            fprintf(fid, "\n");
        end

     else

        for n = 1 : length(select);
            ix = select(n);
            fprintf(fid, "  %6d Re ", nodes.ids(ix))
            fprintf(fid, " %11.3e", real(d(:, ix)));
            fprintf(fid, "\n");
            fprintf(fid, "         Im ")
            fprintf(fid, " %11.3e", imag(d(:, ix)));
            fprintf(fid, "\n");
        end

     end

     fprintf(fid, "\n");

  end

end
