function mfs_prt_disp(fid, nodes, mxdofpnt, disp, title, headers, select)

# usage: mfs_prt_disp(fid, nodes, mxdofpnt, disp, title, headers, select)
#
# Input  fid          File handle
#        nodes        Structure with node data
#        mxdofpnt     Max. number of dofs per node
#        disp(:, :)   Displacements
#        headers      Displacement headers
#        title        Title
#        select       List of indices of nodal points selected for
#                     output
#
# The function prints the displacements.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin < 6 || nargin > 7)
     print_usage();
  end

  nosel = (nargin == 6 || isempty(select));

# Get parameters needed

  nofnod   = nodes.nofnod;
  [m, nlc] = size(disp);

# Loop over loadcases

  for lc = 1 : nlc

     fprintf(fid, "%s %2d\n\n", title, lc);

#    Header

     fprintf(fid, "   node    ");
     for k = 1 : mxdofpnt
         fprintf(fid, "     %3s    ", headers{k});
     end
     fprintf(fid, "\n\n");

#    Loop over nodal points

     d = reshape(disp(:, lc), mxdofpnt, nofnod);

     if (nosel)

        for n = 1 : nofnod
            fprintf(fid, "  %6d  ", nodes.ids(n))
            fprintf(fid, " %11.3e", d(:, n));
            fprintf(fid, "\n");
        end

     else

        for n = 1 : length(select)
            ix = select(n);
            fprintf(fid, "  %6d  ", nodes.ids(ix))
            fprintf(fid, " %11.3e", d(:, ix));
            fprintf(fid, "\n");
        end

     end

     fprintf(fid, "\n");

  end

end
