function mfs_prt_divmodes(fid, cmp, mxdofpnt, headers, select)

# usage: mfs_prt_divmodes(fid, cmp, mxdofpnt, headers, select)
#
# Input  fid       File handle
#        cmp       Structure with component
#        mxdofpnt  Max. number of dofs per node
#        headers   Displacement headers
#        select    List of indices of nodal points selected for
#                  output
#
# The function prints the static divergence modes.
#
# ------------------------------------------------------------------------

# Check arguments

  if (nargin < 4 || nargin > 5)
     print_usage();
  end

  nosel = (nargin == 4 || isempty(select));

# Get parameters needed

  nofnod   = cmp.nodes.nofnod;
  [m, nofmod] = size(cmp.diverg.disp);

# Loop over modes

  for m = 1 : nofmod

     fprintf(fid, "Static divergence mode %2d:", m);
     fprintf(fid, "  Dynamic pressure = %12.4e\n\n", cmp.diverg.qdyn(m));

#    Header

     fprintf(fid, "   node    ");
     for k = 1 : mxdofpnt
         fprintf(fid, "     %3s    ", headers{k});
     end
     fprintf(fid, "\n\n");

#    Loop over nodal points

     d = reshape(cmp.diverg.disp(:, m), mxdofpnt, nofnod);

     if (nosel)

        for n = 1 : nofnod
            fprintf(fid, "  %6d  ", cmp.nodes.ids(n))
            fprintf(fid, " %11.3e", d(:, n));
            fprintf(fid, "\n");
        end

     else

        for n = 1 : length(select)
            ix = select(n);
            fprintf(fid, "  %6d  ", cmp.nodes.ids(ix))
            fprintf(fid, " %11.3e", d(:, ix));
            fprintf(fid, "\n");
        end

     end

     fprintf(fid, "\n");

  end

end
