function mfs_prt_qdyn(fid, cmp)

# usage: mfs_prt_qdyn(fid, cmp)
#
# Input  fid       File handle
#        cmp       Structure with component
#
# The function prints the dynamic pressure at divergence
#
# ------------------------------------------------------------------------

  fprintf(fid, "Dynamic pressure at divergence:\n\n");
  fprintf(fid, "  No.    Dynamic pressure\n");
  fprintf(fid, "  -----------------------\n");

  for m = 1 : cmp.diverg.ndiv
      fprintf(fid, "  %2d      %12.4e\n", m, cmp.diverg.qdyn(m));
  end

  fprintf(fid, "\n");

end
