function nodedata = mfs_resnodedata(data, nodes)

# usage: nodedata = mfs_resnodedata(data, nodes)
#
# Input  data(n)      Structure array with node data
#        nodes        Structure with nodal point data
#
# Output nodedata(n)  Structure array with node data
#                     (Field "res" with resultants added)
#
# ---------------------------------------------------------------------

# Check arguments

  if (nargin != 2 || nargout != 1)
     print_usage();
  end

# Initialize

  nodedata = data;
  nofldc   = length(data);
  ncoor    = nodes.ncoor;

# Loop over loadcases

  for lc = 1 : nofldc

      if (data(lc).nofnod)

         R(1 : ncoor) = sum(data(lc).d(:, 1 : ncoor), 1);
         r            = nodes.coor(data(lc).id, :);
         ndata        = columns(data(lc).d);

         if (ncoor == 2)
            Mz  = r(:, 1) .* data(lc).d(:, 2);
            Mz -= r(:, 2) .* data(lc).d(:, 1);
            R(3) = sum(Mz);
            if (ndata == 3)
               R(3) += sum(data(lc).d(:, 3), 1);
            end
         else
            R(4 : 6) = sum(cross(r, data(lc).d(:, 1 : 3), 2), 1);
            if (ndata == 6)
               R(4 : 6) += sum(data(lc).d(:, 4 : 6), 1);
            end
         end

         nodedata(lc).res = R;

      end

  end

end
